/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.DefaultOptionsInitializer;
import net.blay09.mods.defaultoptions.DefaultOptionsKeyMapping;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.api.DefaultOptionsCategory;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.keys.DefaultKeyMapping;
import net.blay09.mods.defaultoptions.mixin.KeyMappingAccessor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class KeyMappingDefaultsHandler
implements DefaultOptionsHandler {
    private static final Pattern KEY_PATTERN = Pattern.compile("key_([^:]+):([^:]+)(?::(.+))?");
    private static final Map<String, DefaultKeyMapping> defaultKeys = new HashMap<String, DefaultKeyMapping>();

    private File getDefaultOptionsFile() {
        return new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
    }

    @Override
    public String getId() {
        return "keymappings";
    }

    @Override
    public DefaultOptionsCategory getCategory() {
        return DefaultOptionsCategory.KEYS;
    }

    @Override
    public DefaultOptionsLoadStage getLoadStage() {
        return DefaultOptionsLoadStage.POST_LOAD;
    }

    @Override
    public void saveCurrentOptions() {
        Minecraft.m_91087_().f_91066_.m_92169_();
    }

    @Override
    public void saveCurrentOptionsAsDefault() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
                InputConstants.Key key = PlatformBindings.INSTANCE.getKey(keyMapping);
                KeyModifier keyModifier = PlatformBindings.INSTANCE.getKeyModifier(keyMapping);
                writer.println("key_" + keyMapping.m_90860_() + ":" + key.m_84874_() + ":" + keyModifier.name());
            }
        }
        catch (IOException e) {
            DefaultOptions.logger.error("Failed to save default key mappings", (Throwable)e);
        }
        this.loadDefaults();
    }

    @Override
    public boolean hasDefaults() {
        return this.getDefaultOptionsFile().exists();
    }

    @Override
    public boolean shouldLoadDefaults() {
        return true;
    }

    @Override
    public void loadDefaults() {
        DefaultOptionsInitializer.markUserSeenKeys(Minecraft.m_91087_().f_91066_);
        defaultKeys.clear();
        File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
        if (defaultKeysFile.exists()) {
            block18: {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    block9: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty()) continue;
                            Matcher matcher = KEY_PATTERN.matcher(line);
                            if (!matcher.matches()) {
                                DefaultOptions.logger.debug("Skipping line {} as the format is invalid", (Object)line);
                                continue;
                            }
                            try {
                                KeyModifier modifier = matcher.group(3) != null ? KeyModifier.valueOf((String)matcher.group(3)) : KeyModifier.NONE;
                                String keyMappingName = matcher.group(1);
                                defaultKeys.put(keyMappingName, new DefaultKeyMapping(InputConstants.m_84851_((String)matcher.group(2)), modifier));
                                DefaultOptions.logger.debug("Registered a default key binding for {} ({}:{})", (Object)keyMappingName, (Object)matcher.group(2), (Object)matcher.group(3));
                                continue block9;
                            }
                            catch (Exception e) {
                                DefaultOptions.logger.error("Error loading default key binding for {}", (Object)line, (Object)e);
                            }
                        }
                        break block18;
                        {
                            continue block9;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    DefaultOptions.logger.error("Error loading default key bindings", (Throwable)e);
                }
            }
            DefaultOptions.logger.info("Loaded {} default key bindings.", (Object)defaultKeys.size());
        } else {
            DefaultOptions.logger.info("No default key bindings file found.");
        }
        int defaultsApplied = 0;
        int bindingsOverridden = 0;
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            DefaultKeyMapping originalDefaultMapping = new DefaultKeyMapping(keyMapping.m_90861_(), PlatformBindings.INSTANCE.getDefaultKeyModifier(keyMapping));
            if (defaultKeys.containsKey(keyMapping.m_90860_())) {
                DefaultKeyMapping defaultKeyMapping = defaultKeys.get(keyMapping.m_90860_());
                ((KeyMappingAccessor)keyMapping).setDefaultKey(defaultKeyMapping.input);
                PlatformBindings.INSTANCE.setDefaultKeyModifier(keyMapping, defaultKeyMapping.modifier);
                ++defaultsApplied;
                if (!((DefaultOptionsKeyMapping)keyMapping).defaultoptions$wasSeen() && originalDefaultMapping.matches(keyMapping) && !defaultKeyMapping.matches(keyMapping)) {
                    KeyModifier defaultKeyModifier = PlatformBindings.INSTANCE.getDefaultKeyModifier(keyMapping);
                    PlatformBindings.INSTANCE.setKeyModifier(keyMapping, defaultKeyModifier);
                    keyMapping.m_90848_(keyMapping.m_90861_());
                    ++bindingsOverridden;
                    DefaultOptions.logger.debug("Key mapping {} was previously on the original default. Configuring to new default.", (Object)keyMapping.m_90860_());
                    continue;
                }
                DefaultOptions.logger.debug("Key mapping {} has been previously set, skipping.", (Object)keyMapping.m_90860_());
                continue;
            }
            DefaultOptions.logger.debug("No default key mapping configured for {}, skipping.", (Object)keyMapping.m_90860_());
        }
        DefaultOptions.logger.info("Applied {} defaults to key mappings ({} keys were reconfigured).", (Object)defaultsApplied, (Object)bindingsOverridden);
        if (bindingsOverridden > 0) {
            KeyMapping.m_90854_();
            this.saveCurrentOptions();
        }
    }
}

